/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;

public class AmbientLightingBatch
implements Disposable {
    private static final int NUM_VERTICES_PER_QUAD = 4;
    private static final int NUM_INDICES_PER_QUAD = 6;
    private static final int VERTEX_SIZE = 3;
    private static final int SPRITE_SIZE = 12;
    private Mesh mesh;
    final float[] vertices;
    int idx = 0;
    boolean drawing = false;
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private int blendSrcFunc = 770;
    private int blendDstFunc = 771;
    private final ShaderProgram shader;
    Color color = Color.WHITE;
    public int renderCalls = 0;
    public int totalRenderCalls = 0;
    public int maxSpritesInBatch = 0;

    public AmbientLightingBatch(int maxNumQuads, ShaderProgram shader) {
        if (maxNumQuads > 5460) {
            throw new IllegalArgumentException("Can't have more than 5460 sprites per batch: " + maxNumQuads);
        }
        Mesh.VertexDataType vertexDataType = Mesh.VertexDataType.VertexArray;
        if (Gdx.gl30 != null) {
            vertexDataType = Mesh.VertexDataType.VertexBufferObjectWithVAO;
        }
        this.mesh = new Mesh(vertexDataType, false, maxNumQuads * 4, maxNumQuads * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(32, 1, "a_luminosity"));
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.vertices = new float[maxNumQuads * 12];
        int len = maxNumQuads * 6;
        short[] indices = new short[len];
        short j = 0;
        int i = 0;
        while (i < len) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.mesh.setIndices(indices);
        this.shader = shader;
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("SpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        Gdx.gl.glDepthMask(false);
        this.shader.begin();
        this.shader.setUniformf("u_lightColor", new Vector3(this.color.r, this.color.g, this.color.b));
        this.setupMatrices();
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before end.");
        }
        if (this.idx > 0) {
            this.flush();
        }
        this.drawing = false;
        GL20 gl = Gdx.gl;
        gl.glDepthMask(true);
        this.shader.end();
    }

    public void setColor(Color tint) {
        this.color = tint;
    }

    public void draw(float x, float y, float width, float height, float luminositySW, float luminosityNW, float luminosityNE, float luminositySE) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        if (this.idx == this.vertices.length) {
            this.flush();
        }
        float xPlusWidth = x + width;
        float yPlusHeight = y + height;
        this.vertices[this.idx++] = x;
        this.vertices[this.idx++] = y;
        this.vertices[this.idx++] = luminositySW;
        this.vertices[this.idx++] = x;
        this.vertices[this.idx++] = yPlusHeight;
        this.vertices[this.idx++] = luminosityNW;
        this.vertices[this.idx++] = xPlusWidth;
        this.vertices[this.idx++] = yPlusHeight;
        this.vertices[this.idx++] = luminosityNE;
        this.vertices[this.idx++] = xPlusWidth;
        this.vertices[this.idx++] = y;
        this.vertices[this.idx++] = luminositySE;
    }

    public void flush() {
        if (this.idx == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int spritesInBatch = this.idx / 12;
        if (spritesInBatch > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = spritesInBatch;
        }
        int count = spritesInBatch * 6;
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.idx);
        mesh.getIndicesBuffer().position(0);
        mesh.getIndicesBuffer().limit(count);
        Gdx.gl.glEnable(3042);
        if (this.blendSrcFunc != -1) {
            Gdx.gl.glBlendFunc(this.blendSrcFunc, this.blendDstFunc);
        }
        mesh.render(this.shader, 4, 0, count);
        this.idx = 0;
    }

    public void setBlendFunction(int srcFunc, int dstFunc) {
        if (this.blendSrcFunc == srcFunc && this.blendDstFunc == dstFunc) {
            return;
        }
        this.flush();
        this.blendSrcFunc = srcFunc;
        this.blendDstFunc = dstFunc;
    }

    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setProjectionMatrix(Matrix4 projection) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(projection);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    public void setTransformMatrix(Matrix4 transform) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(transform);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
    }

    public boolean isDrawing() {
        return this.drawing;
    }
}

